/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************/

#include <hidef.h>		/* common defines and macros */
#include "derivative.h"		/* derivative-specific definitions */
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "EEEGlobals.h"
#include "EEE.h"


/*************************************************************************************/

void main(void)

 {

 /* Variable Declarations */
 
  EEE_Error Error;
  uchar x;

 /* Begin Function main() */
 
  EnableInterrupts;

  Error = EEEInit(NULL);

  PORTA = 0x01;				/* used for ISR timing measurements */
  DDRA = 0x01;

  for (x = 0; x < 0x7f; x++)		/* just write some stuff to the EEE to test the functionality */
   {
    Error = EEEWrite(x + 1, x);
    while (EEEState != EEE_Idle)
     ;
    if (EEEError != EEE_noErr)
     break;
   }


  Error = EEEWrite(5 + x, 0x41 + x);
  while (EEEState != EEE_Idle)
   ;

 while(1)
  ;

 }	/* end main */

/*************************************************************************************/
